clear; close all
qbit=1;showfig = 0;

Nsub=256;   % no. of subcarriers for rate computation
Ngrid = 1000;
L = 1;

% factor = 2.5;
% x1 = 40e-1*factor;
% y1 = 50e-1*ones(size(factor));
% z1 = 90e-1*factor;
% x2 = -30e-1*factor;
% y2 = 50e-1*ones(size(factor));
% z2 = 40e-1*factor;
% TRX = zeros(6,length(factor));
% TRX(1,:) = x1;
% TRX(2,:) = y1;
% TRX(3,:) = z1;
% TRX(4,:) = x2;
% TRX(5,:) = y2;
% TRX(6,:) = z2;
load('TRX_same_dist20.mat','TRX','NTRX')
NTRX = 2000;
dist = rms(TRX(1:3,:))*sqrt(3)+rms(TRX(4:6,:))*sqrt(3);

Dist = 1*logspace(0,2,9);

fc = 30e9;
c = 3e8;
BW_des = 1.5e9;
Ptx = 10;%dBm
Ptx1 = 30;

cal_rate = 0;
if cal_rate

Rates = zeros(4,length(Dist),NTRX);
Rates1 = zeros(3,length(Dist),NTRX);
Ratessub = Rates;
for n = 1:length(Dist)
    TRX1 = TRX*sqrt(Dist(n)/20);
    parfor m = 1:NTRX
   Rates(:,n,m) = my_compute_rate_NUSW(10,Nsub,L,TRX1(:,m),fc,BW_des,Ptx,showfig); 
   % Rates1(:,n,m) = my_compute_rate(10,Nsub,L,TRX1(:,m),fc,BW_des,Ptx1,showfig); 
    % Rates(4:6,n) = my_compute_rate(1,Nsub,L,TRX,fc,BW_des(n),Ptx,showfig); 
    % Rates(7:9,n) = my_compute_rate(2,Nsub,L,TRX,fc,BW_des(n),Ptx,showfig); 
    % Rates(10:12,n) = my_compute_rate(3,Nsub,L,TRX,fc,BW_des(n),Ptx,showfig); 
    end
    disp(n)
end
Rates = mean(Rates,3);
Rates1 = mean(Rates1,3);
Ratessub = mean(Ratessub,3);
MSE = rms(Rates(2,:,:)-Rates(4,:,:),3)./rms(Rates(2,:,:),3);
save('data/Rates_sum_rate_vs_dist_NUSW.mat','Rates','Dist','Rates1','Ptx1','Ptx',"MSE")

else 
    load('data/Rates_sum_rate_vs_dist_NUSW.mat')
end

semilogx(Dist,Rates(3,:),'--','LineWidth',2) % optimal
hold on
grid on
semilogx(Dist,Rates(2,:),'v-','LineWidth',2) % proposed
semilogx(Dist,Rates(4,:),'k^--','LineWidth',2); % classial

% semilogx(Dist,Rates1(3,:),'-.','LineWidth',1.5) % optimal
% semilogx(Dist,Rates1(2,:),'d-','LineWidth',1.5) % proposed
% semilogx(Dist,Rates1(1,:),'o--','LineWidth',1.5,'Color',[0 0 0.6]); % classial
semilogx(Dist,Rates(1,:),'d--','LineWidth',2)

semilogx(Dist(1),0)
xlim ([Dist(1), Dist(end)])
xlabel('Total route length {\it l} (m)')
ylabel('Average rate (bit/s)')
legend('Optimal beamforming','Proposed method (USW model)',...
    'Proposed method (NUSW model)','Classical beamforming',...
    'Location','northeast', 'FontSize', 14)
hold off
set(get(gca, 'Legend'), 'Box', 'off'); 
set(gca, 'FontSize', 16);
set(gca,'FontName','Times New Roman')
set(gcf, 'Position', [100 100 600 500]); % 调整当前图窗的大小
set(0, 'DefaultAxesFontName', 'Times New Roman');
hold off
saveas(gcf,'fig/Fig_sum_rate_vs_dist_NUSW.fig')
saveas(gcf,'fig/Fig_sum_rate_vs_dist_NUSW.png')

